//
//  uninstallerPane.m
//  uninstaller
//
//  Created by kts on 7/31/12.
//  Copyright (c) 2012 kettek. All rights reserved.
//

#import "uninstallerPane.h"


@implementation uninstallerPane

- (NSString *)title
{
	return [[NSBundle bundleForClass:[self class]] localizedStringForKey:@"PaneTitle" value:nil table:nil];
}

- (void)willEnterPane:(InstallerSectionDirection)aDir
{
	// The following gets the plist of the parent package so we can read in our packages to uninstall list
	NSString *bundlePath = [[NSBundle bundleForClass:[self class]] resourcePath];
	NSString *parentBundlePath = [[[[bundlePath stringByDeletingLastPathComponent] stringByDeletingLastPathComponent]
		stringByDeletingLastPathComponent] stringByDeletingLastPathComponent];
	NSBundle *parentbundle = [NSBundle bundleWithPath:parentBundlePath];
	NSString *parentInfoPlistPath = [parentbundle pathForResource:@"Info" ofType:@"plist"];
	NSMutableDictionary *parentInfoPlist = [NSDictionary dictionaryWithContentsOfFile:parentInfoPlistPath];

	// Get our array of packages to uninstall
	NSArray *UninstallTargets = [parentInfoPlist objectForKey:@"IFPkgFlagUninstallList"];
	
	bool uninstallDialog = false;
	
	NSDictionary *targetPayload;

	NSEnumerator *e = [UninstallTargets objectEnumerator];
	NSString *object;
	while (object = [e nextObject]) {
		targetPayload  = [[[self section] installerState] 
			choiceDictionaryForIdentifier:object];
		if ([[targetPayload objectForKey:@"Choice_Installed"] intValue] != 0) {
			uninstallDialog = true;
		}
	}
	
	// Skip uninstall panel if our target uninstall package is not selected.
	if (uninstallDialog == false) {
		[self gotoNextPane];
	// Otherwise, enable back and next button.
	} else {
		[self setNextEnabled:YES];
		[self setPreviousEnabled:YES];
	}
	[[self nextPane] setPreviousEnabled:NO];
}

- (BOOL)shouldExitPane:(InstallerSectionDirection)aDir
{
	if (aDir == InstallerDirectionForward) {
		[NSApp terminate:nil];
	}
	return true;
}

@end
